import '../../components/Cards/MainCard.css'
import "swiper/css";
import "swiper/css/virtual";
import { Swiper, SwiperSlide } from "swiper/react";
import { Virtual, Navigation } from "swiper/modules";

import PlanTwo from "./PlanTwo";
import PlanThree from "./PlanThree";
import PlanFour from "./PlanFour";



const FiberPlans = ({ inputElement, handleCallbackButtonClick }) => {
  const slidesArray = [
    <PlanTwo handleCallbackButtonClick={handleCallbackButtonClick} />,
    <PlanThree handleCallbackButtonClick={handleCallbackButtonClick} />,
    <PlanFour handleCallbackButtonClick={handleCallbackButtonClick} />,
  ];

  return (
    <div className="slider_container">
      <div className="plan_header" ref={inputElement}>
        <h2 className="el_title">du Home Plans</h2>
        <div className="control_keys">
          <img className="swiper-button-prev" src="/images/icon-carousel-prev.svg" alt="prev" />
          <img className="swiper-button-next" src="/images/icon-carousel-next.svg" alt="next" />
        </div>
      </div>
      <Swiper
        modules={[Virtual, Navigation]}
        spaceBetween={20}
        navigation={{
          prevEl: ".swiper-button-prev",
          nextEl: ".swiper-button-next",
        }}
        slidesPerView={3}
        virtual
        breakpoints={{
          300: {
            slidesPerView: 1,
          },
          600: {
            slidesPerView: 2,
            spaceBetween: 10,
          },
          900: {
            slidesPerView: 3,
            spaceBetween: 20,
          },
        }}
      >
        {slidesArray.map((slideContent, index) => (
          <SwiperSlide key={slideContent} virtualIndex={index}>
            {slideContent}
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
};

export default FiberPlans;
